<?php

namespace Genealogy\App\Model;

use Genealogy\App\Model\BaseModel;
use Genealogy\Include\PersonPrivacy;
use Genealogy\Include\PersonName;
use Genealogy\Include\Ancestors;
use Genealogy\Include\Descendants;
use PDO;

class MapsModel extends BaseModel
{
    // *** Get selected world map ***
    public function select_world_map(): string
    {
        $select = 'Google';
        if (isset($this->humo_option["use_world_map"]) && $this->humo_option["use_world_map"] == 'OpenStreetMap') {
            $select = 'OpenStreetMap';
        }
        return $select;
    }

    // *** Get list of selected family names ***
    public function get_family_names(): string|array
    {
        $family_names = '';
        if (isset($_POST['items'])) {
            $family_names = $_POST['items'];
        }
        return $family_names;
    }

    // *** Show line of selected family names ***
    public function show_family_names($family_names): string
    {
        $names = '';
        if ($family_names) {
            foreach ($family_names as $value) {
                $pos = strpos($value, '_');
                $pref = substr($value, $pos + 1);
                if ($pref !== '') {
                    $pref .= ' ';
                }
                $last = substr($value, 0, $pos);
                $names .= $pref . $last . ", ";
            }
            $names = substr($names, 0, -2); // take off last ", "
        }
        return $names;
    }

    public function get_maps_type(): array
    {
        // *** Set birth or death display. Default values ***
        // *** BE AWARE: session values are used in google_initiate script. If these are disabled, the slider doesn't work ***
        $maps['display_birth'] = true;
        $maps['display_death'] = false;
        if (!isset($_SESSION['type_death']) && !isset($_SESSION['type_death'])) {
            $_SESSION['type_birth'] = 1;
            $_SESSION['type_death'] = 0;
        }
        if (isset($_SESSION['type_death']) && $_SESSION['type_death'] == 1) {
            $maps['display_death'] = true;
            $maps['display_birth'] = false;
        }
        if (isset($_POST['map_type']) && $_POST['map_type'] == "type_birth") {
            $_SESSION['type_birth'] = 1;
            $_SESSION['type_death'] = 0;
            $maps['display_birth'] = true;
            $maps['display_death'] = false;
        }
        if (isset($_POST['map_type']) && $_POST['map_type'] == "type_death") {
            $_SESSION['type_death'] = 1;
            $_SESSION['type_birth'] = 0;
            $maps['display_death'] = true;
            $maps['display_birth'] = false;
        }
        return $maps;
    }

    // *** Slider settings ***
    public function get_slider_settings($tree_prefix_quoted): array
    {
        // *** Slider defaults ***
        $maps['slider_min'] = 1560;  // first year shown on slider
        $maps['slider_step'] = "50";     // interval
        $maps['slider_off'] = "1510"; // OFF position (first year minus step, year is not shown)
        $maps['slider_year'] = date("Y");

        // check for stored min value, created with google maps admin menu
        $query = "SELECT setting_value FROM humo_settings WHERE setting_variable='gslider_" . $tree_prefix_quoted . "' ";
        $result = $this->dbh->query($query);
        if ($result->rowCount() > 0) {
            $sliderDb = $result->fetch(PDO::FETCH_OBJ);
            $maps['slider_min'] = $sliderDb->setting_value;
            $maps['slider_step'] = floor(($maps['slider_year'] - $maps['slider_min']) / 9);
            $maps['slider_off'] = $maps['slider_min'] - $maps['slider_step'];
        }

        $qry = "SELECT setting_value FROM humo_settings WHERE setting_variable='gslider_default_pos'";
        $result = $this->dbh->query($qry);
        if ($result->rowCount() > 0) {
            $def = $result->fetch(); // defaults to array
            if ($def['setting_value'] == "off") {
                // slider at leftmost position
                $maps['slider_default_year'] = $maps['slider_off'];
                $maps['slider_default_display'] = "------>";
                $maps['slider_makesel'] = "";
            } else {
                // slider ar rightmost position
                $maps['slider_default_year'] = $maps['slider_year'];
                $maps['slider_default_display'] = $maps['slider_default_year'];
                $maps['slider_makesel'] = " makeSelection(3); ";
            }
        } else {
            //$maps['slider_default_year'] = $maps['slider_off']; $maps['slider_default_display'] = "------>"; $maps['slider_makesel']=""; // slider at leftmost position 
            $maps['slider_default_year'] = $maps['slider_year'];
            $maps['slider_default_display'] = $maps['slider_default_year'];
            $maps['slider_makesel'] = " makeSelection(3); ";  // slider at rightmost position (default)
        }
        return $maps;
    }

    public function get_maps_descendants(): array
    {
        global $desc_array;

        $descendants = new Descendants;

        // *** Find descendants of chosen person ***
        $maps['desc_chosen_name'] = '';
        $maps['desc_array'] = '';

        $_SESSION['desc_array'] = '';

        // *** Example: persged=I529&persfams=F191;F192. In nov. 2025 changed into: persfams=1 (only needed for selection) ***
        if (isset($_GET['persged']) && isset($_GET['persfams'])) {
            $chosenperson = $_GET['persged'];
            $person = $this->db_functions->get_person($chosenperson);
            $firstRelation = $this->db_functions->get_first_relation($person->pers_id);

            // Also check privacy
            $chosenname = $person->pers_firstname . ' ' . strtolower(str_replace('_', '', $person->pers_prefix)) . ' ' . $person->pers_lastname;

            // *** Start function here - recursive if started ***
            $desc_array = [];

            // EXAMPLE: $descendants->get_descendants($family_id,$main_person,$nr_generations);
            $descendant_array = $descendants->get_descendants($firstRelation->relation_gedcomnumber, $chosenperson, 20);
            $desc_array = $descendant_array;

            if ($desc_array != '') {
                $desc_array = array_unique($desc_array); // removes duplicate persons (because of related ancestors)
                $_SESSION['desc_array'] = $desc_array; // for use in namesearch.php

                $maps['desc_chosen_name'] = $chosenname;
                $maps['desc_array'] = $desc_array;
            }
        } else {
            unset($_SESSION['desc_array']);
        }

        return $maps;
    }

    public function get_maps_ancestors(): array
    {
        // *** Find ancestors ***
        global $anc_array;

        $ancestors = new Ancestors;

        $_SESSION['anc_array'] = '';
        if (isset($_GET['anc_persged'])) {
            $chosenperson = $_GET['anc_persged'];
            //also check privacy
            $myresult = $this->dbh->query("SELECT pers_lastname, pers_firstname, pers_prefix FROM humo_persons WHERE pers_tree_id='" . $this->tree_id . "' AND pers_gedcomnumber='" . $chosenperson . "'");
            $myresultDb = $myresult->fetch(PDO::FETCH_OBJ);
            $chosenname = $myresultDb->pers_firstname . ' ' . strtolower(str_replace('_', '', $myresultDb->pers_prefix)) . ' ' . $myresultDb->pers_lastname;
            $anc_array = $ancestors->get_ancestors($this->db_functions, $chosenperson);
            $_SESSION['anc_array'] = $anc_array; // for use in namesearch.php
        } else {
            $chosenname = '';
            $anc_array = '';
            unset($_SESSION['anc_array']);
        }

        $maps['chosen_name'] = $chosenname;
        $maps['anc_array'] = $anc_array;
        return $maps;
    }

    // *** Sept. 2024: at this moment only used for OpenStreetMap ***
    public function get_locations($maps): array
    {
        $maps['location'][] = '';
        $maps['latitude'][] = '';
        $maps['longitude'][] = '';
        $maps['location_text'][] = '';
        $maps['location_text_count'][] = '';

        $personPrivacy = new PersonPrivacy();
        $personName = new PersonName();

        $namesearch_string = '';
        if ($maps['family_names'] != '') {
            $namesearch_string = ' AND (';
            foreach ($maps['family_names'] as $value) {
                //$namesearch_string .= " pers_lastname = '".$value."' OR ";
                //$namesearch_string .= " totalname = '".$value."' OR ";
                $namesearch_string .= "CONCAT(pers_lastname,'_',LOWER(SUBSTRING_INDEX(pers_prefix,'_',1))) = '" . $value . "' OR ";
            }
            $namesearch_string = substr($namesearch_string, 0, -3) . ")"; // take off last "OR "
        }

        if ($maps['display_birth']) {
            /*
            $person_results = $this->dbh->query("SELECT * FROM humo_location LEFT JOIN humo_persons
                ON humo_location.location_location = humo_persons.pers_birth_place
                OR humo_location.location_location = humo_persons.pers_bapt_place
                WHERE location_lat IS NOT NULL AND pers_tree_id='" . $this->tree_id . "'");
            */

            $person_results = $this->dbh->query(
                "SELECT 
                    humo_location.*, 
                    humo_persons.*, 
                    humo_events.event_connect_id,
                    humo_events.place_id AS birth_place_id,
                    l_birth.location_location AS pers_birth_place
                FROM humo_location
                LEFT JOIN humo_events 
                    ON humo_events.event_kind = 'birth'
                    AND humo_events.place_id = humo_location.location_id
                LEFT JOIN humo_persons 
                    ON humo_persons.pers_id = humo_events.person_id
                LEFT JOIN humo_location l_birth
                    ON l_birth.location_id = humo_events.place_id
                WHERE humo_location.location_lat IS NOT NULL
                    AND humo_persons.pers_tree_id='" . $this->tree_id . "' " . $namesearch_string . "
                ORDER BY humo_location.location_location"
            );
        } elseif ($maps['display_death']) {
            /*
            $person_results = $this->dbh->query("SELECT * FROM humo_location LEFT JOIN humo_persons
                ON humo_location.location_location = humo_persons.pers_death_place
                OR humo_location.location_location = humo_persons.pers_buried_place
                WHERE location_lat IS NOT NULL AND pers_tree_id='" . $this->tree_id . "'");
            */

            $person_results = $this->dbh->query(
                "SELECT 
                    humo_location.*, 
                    humo_persons.*, 
                    humo_events.event_connect_id,
                    humo_events.place_id AS death_place_id,
                    l_death.location_location AS pers_death_place
                FROM humo_location
                LEFT JOIN humo_events 
                    ON humo_events.event_kind = 'death'
                    AND humo_events.place_id = humo_location.location_id
                LEFT JOIN humo_persons 
                    ON humo_persons.pers_id = humo_events.person_id
                LEFT JOIN humo_location l_death
                    ON l_death.location_id = humo_events.place_id
                WHERE humo_location.location_lat IS NOT NULL
                    AND humo_persons.pers_tree_id='" . $this->tree_id . "' " . $namesearch_string . "
                ORDER BY humo_location.location_location"
            );
        }

        while ($personDb = $person_results->fetch(PDO::FETCH_OBJ)) {
            if ($maps['display_birth']) {
                $place = $personDb->pers_birth_place;
                //$date = $personDb->pers_birth_date;
                //if (!$personDb->pers_birth_place && $personDb->pers_bapt_place) {
                //    $place = $personDb->pers_bapt_place;
                //}
                //if (!$personDb->pers_birth_date && $personDb->pers_bapt_date) {
                //    $date = $personDb->pers_bapt_date;
                //}
            } elseif ($maps['display_death']) {
                $place = $personDb->pers_death_place;
                //$date = $personDb->pers_death_date;

                // TODO Check (also for birth/ bapt): $personDb->location_location.
                // Could be different if death and burial places are different.
                // Something like this (query will find death place and buried place in 2 rows):
                //if (!$personDb->pers_death_place && $personDb->pers_buried_place==$personDb->location_location) {
                //    $place = $personDb->pers_buried_place;
                //    // Maybe show a [] character for person?
                //}

                //if (!$personDb->pers_death_place && $personDb->pers_buried_place) {
                //    $place = $personDb->pers_buried_place;
                //}
                //if (!$personDb->pers_death_date && $personDb->pers_buried_date) {
                //    $date = $personDb->pers_buried_date;
                //}
            }

            $person2Db = $this->db_functions->get_person_with_id($personDb->pers_id);
            $privacy = $personPrivacy->get_privacy($person2Db);
            $name = $personName->get_person_name($person2Db, $privacy);

            $key = array_search(htmlspecialchars($place), $maps['location']);
            if (isset($key) && $key > 0) {
                // *** Check the number of lines of the text_array ***
                $maps['location_text_count'][$key]++;
                // *** For now: limited results in text box of OpenStreetMap ***
                if ($maps['location_text_count'][$key] < 26) {
                    $maps['location_text'][$key] .= '<br>' . addslashes($name["standard_name"]);
                }
                if ($maps['location_text_count'][$key] == 26) {
                    $maps['location_text'][$key] .= '<br>' . __('Results are limited.');
                }
            } else {
                // *** Add location to array ***
                $maps['location'][] = htmlspecialchars($place);
                $maps['latitude'][] = $personDb->location_lat;
                $maps['longitude'][] = $personDb->location_lng;

                $maps['location_text'][] = addslashes('<h4>' . $place . '</h4>' . $name["standard_name"]);
                $maps['location_text_count'][] = 1; // *** Number of text lines ***
            }
        }
        return $maps;
    }

    // TODO: this function should be rebuild. Use date_year, and locarray isn't needed anymore?
    // Also get relation dates from events table?
    public function get_locations_google($maps): array
    {
        // TODO probably better not to load all places. Combine queries?
        // Allready done for openstreetmap.
        $locarray = [];
        $location = $this->dbh->query("SELECT location_id, location_location, location_lat, location_lng FROM humo_location WHERE location_lat IS NOT NULL ORDER BY location_location");
        while ($locationDb = $location->fetch(PDO::FETCH_OBJ)) {
            $locarray[$locationDb->location_location][0] = htmlspecialchars($locationDb->location_location);
            $locarray[$locationDb->location_location][1] = $locationDb->location_lat;
            $locarray[$locationDb->location_location][2] = $locationDb->location_lng;
            $locarray[$locationDb->location_location][3] = 0;    // till starting year  (depending on settings)
            $locarray[$locationDb->location_location][4] = 0;    // + 1 interval
            $locarray[$locationDb->location_location][5] = 0;    // + 2 intervals
            $locarray[$locationDb->location_location][6] = 0;    // + 3 intervals
            $locarray[$locationDb->location_location][7] = 0;    // + 4 intervals
            $locarray[$locationDb->location_location][8] = 0;    // + 5 intervals
            $locarray[$locationDb->location_location][9] = 0;    // + 6 intervals
            $locarray[$locationDb->location_location][10] = 0;   // + 7 intervals
            $locarray[$locationDb->location_location][11] = 0;   // + 8 intervals
            $locarray[$locationDb->location_location][12] = 0;   // till today (=2010 and beyond)
            $locarray[$locationDb->location_location][13] = 0;   // all

            // *** Added 15-09-2024 ***
            $locarray[$locationDb->location_location][14] = $locationDb->location_id;
        }

        if (isset($maps['desc_array']) && $maps['desc_array'] != '') {
            $desc_asc_array = $maps['desc_array'];
        } elseif (isset($maps['anc_array']) && $maps['anc_array'] != '') {
            $desc_asc_array = $maps['anc_array'];
        }

        if (isset($desc_asc_array) && $desc_asc_array != '') {
            foreach ($desc_asc_array as $value) {
                if ($_SESSION['type_birth'] == 1) {
                    /*
                    $person_results = $this->dbh->query("SELECT pers_firstname, pers_birth_place, pers_birth_date, pers_bapt_place, pers_bapt_date
                        FROM humo_persons WHERE pers_tree_id='" . $this->tree_id . "'
                        AND pers_gedcomnumber ='" . $value . "'
                        AND (pers_birth_place !='' OR (pers_birth_place ='' AND pers_bapt_place !=''))");
                    */

                    // TODO use join. Prebuild array not needed anymore.
                    //$person_results = $this->dbh->query("SELECT * FROM humo_location LEFT JOIN humo_persons
                    //ON humo_location.location_location = humo_persons.pers_birth_place
                    //OR humo_location.location_location = humo_persons.pers_bapt_place
                    //WHERE location_lat IS NOT NULL AND pers_tree_id='" . $this->tree_id . "'");

                    $person_results = $this->dbh->query(
                        "SELECT 
                            p.pers_firstname, 
                            e_birth.place_id AS birth_place_id,
                            l_birth.location_location AS pers_birth_place,
                            e_birth.event_date AS pers_birth_date,
                            e_bapt.place_id AS bapt_place_id,
                            l_bapt.location_location AS pers_bapt_place,
                            e_bapt.event_date AS pers_bapt_date
                        FROM humo_persons p
                        LEFT JOIN humo_events e_birth 
                            ON e_birth.event_kind = 'birth'
                            AND e_birth.event_connect_id = p.pers_gedcomnumber
                            AND e_birth.event_tree_id = p.pers_tree_id
                        LEFT JOIN humo_events e_bapt 
                            ON e_bapt.event_kind = 'baptism'
                            AND e_bapt.event_connect_id = p.pers_gedcomnumber
                            AND e_bapt.event_tree_id = p.pers_tree_id
                        LEFT JOIN humo_location l_birth
                            ON l_birth.location_id = e_birth.place_id
                        LEFT JOIN humo_location l_bapt
                            ON l_bapt.location_id = e_bapt.place_id
                        WHERE p.pers_tree_id='" . $this->tree_id . "'
                            AND p.pers_gedcomnumber ='" . $value . "'
                            AND (e_birth.place_id IS NOT NULL OR e_bapt.place_id IS NOT NULL)"
                    );


                    $personDb = $person_results->fetch(PDO::FETCH_OBJ);
                } elseif ($_SESSION['type_death'] == 1) {
                    /*
                    $person_results = $this->dbh->query("SELECT pers_firstname, pers_death_place, pers_death_date, pers_buried_place, pers_buried_date
                        FROM humo_persons WHERE pers_tree_id='" . $this->tree_id . "'
                        AND pers_gedcomnumber ='" . $value . "'
                        AND (pers_death_place !='' OR (pers_death_place ='' AND pers_buried_place !=''))");
                    */

                    $person_results = $this->dbh->query(
                        "SELECT 
                            p.pers_firstname, 
                            e_death.place_id AS death_place_id,
                            l_death.location_location AS pers_death_place,
                            e_death.event_date AS pers_death_date,
                            e_burial.place_id AS buried_place_id,
                            l_burial.location_location AS pers_buried_place,
                            e_burial.event_date AS pers_buried_date
                        FROM humo_persons p
                        LEFT JOIN humo_events e_death 
                            ON e_death.event_kind = 'death'
                            AND e_death.event_connect_id = p.pers_gedcomnumber
                            AND e_death.event_tree_id = p.pers_tree_id
                        LEFT JOIN humo_events e_burial 
                            ON e_burial.event_kind = 'burial'
                            AND e_burial.event_connect_id = p.pers_gedcomnumber
                            AND e_burial.event_tree_id = p.pers_tree_id
                        LEFT JOIN humo_location l_death
                            ON l_death.location_id = e_death.place_id
                        LEFT JOIN humo_location l_burial
                            ON l_burial.location_id = e_burial.place_id
                        WHERE p.pers_tree_id='" . $this->tree_id . "'
                            AND p.pers_gedcomnumber ='" . $value . "'
                            AND (e_death.place_id IS NOT NULL OR e_burial.place_id IS NOT NULL)"
                    );

                    $personDb = $person_results->fetch(PDO::FETCH_OBJ);
                }
                if ($personDb) {
                    if ($_SESSION['type_birth'] == 1) {
                        $place = $personDb->pers_birth_place;
                        $date = $personDb->pers_birth_date;
                        if (!$personDb->pers_birth_place and $personDb->pers_bapt_place) {
                            $place = $personDb->pers_bapt_place;
                        }
                        if (!$personDb->pers_birth_date and $personDb->pers_bapt_date) {
                            $date = $personDb->pers_bapt_date;
                        }
                    } elseif ($_SESSION['type_death'] == 1) {
                        $place = $personDb->pers_death_place;
                        $date = $personDb->pers_death_date;
                        if (!$personDb->pers_death_place and $personDb->pers_buried_place) {
                            $place = $personDb->pers_buried_place;
                        }
                        if (!$personDb->pers_death_date and $personDb->pers_buried_date) {
                            $date = $personDb->pers_buried_date;
                        }
                    }

                    if (isset($locarray[$place])) {
                        // birthplace exists in location database
                        if ($date) {
                            // TODO use new date_year field
                            $year = substr($date, -4);

                            if ($year > 1 and $year < $maps['slider_min']) {
                                $locarray[$place][3]++;
                            }
                            if ($year > 1 and $year < ($maps['slider_min'] + $maps['slider_step'])) {
                                $locarray[$place][4]++;
                            }
                            if ($year > 1 and $year < ($maps['slider_min'] + (2 * $maps['slider_step']))) {
                                $locarray[$place][5]++;
                            }
                            if ($year > 1 and $year < ($maps['slider_min'] + (3 * $maps['slider_step']))) {
                                $locarray[$place][6]++;
                            }
                            if ($year > 1 and $year < ($maps['slider_min'] + (4 * $maps['slider_step']))) {
                                $locarray[$place][7]++;
                            }
                            if ($year > 1 and $year < ($maps['slider_min'] + (5 * $maps['slider_step']))) {
                                $locarray[$place][8]++;
                            }
                            if ($year > 1 and $year < ($maps['slider_min'] + (6 * $maps['slider_step']))) {
                                $locarray[$place][9]++;
                            }
                            if ($year > 1 and $year < ($maps['slider_min'] + (7 * $maps['slider_step']))) {
                                $locarray[$place][10]++;
                            }
                            if ($year > 1 and $year < ($maps['slider_min'] + (8 * $maps['slider_step']))) {
                                $locarray[$place][11]++;
                            }
                            if ($year > 1 and $year < 2100) {
                                $locarray[$place][12]++;
                            }
                            $locarray[$place][13]++;  // array of all people incl people without birth date
                        } else {
                            $locarray[$place][13]++; // array of all people incl people without birth date
                        }
                    }
                }
            }
        } else {
            $namesearch_string = '';
            if ($maps['family_names'] != '') {
                $namesearch_string = ' AND (';
                foreach ($maps['family_names'] as $value) {
                    //$namesearch_string .= " pers_lastname = '".$value."' OR ";
                    //$namesearch_string .= " totalname = '".$value."' OR ";
                    $namesearch_string .= "CONCAT(pers_lastname,'_',LOWER(SUBSTRING_INDEX(pers_prefix,'_',1))) = '" . $value . "' OR ";
                }
                $namesearch_string = substr($namesearch_string, 0, -3) . ")"; // take off last "OR "
            }

            if ($_SESSION['type_birth'] == 1) {
                $person_results = $this->dbh->query(
                    "SELECT 
                        l_birth.location_location AS pers_birth_place,
                        l_bapt.location_location AS pers_bapt_place,
                        e_birth.event_date AS pers_birth_date,
                        e_bapt.event_date AS pers_bapt_date
                    FROM humo_persons p
                    LEFT JOIN humo_events e_birth 
                        ON e_birth.event_kind = 'birth'
                        AND e_birth.person_id = p.pers_id
                        AND e_birth.event_tree_id = p.pers_tree_id
                    LEFT JOIN humo_events e_bapt 
                        ON e_bapt.event_kind = 'baptism'
                        AND e_bapt.person_id = p.pers_id
                        AND e_bapt.event_tree_id = p.pers_tree_id
                    LEFT JOIN humo_location l_birth
                        ON l_birth.location_id = e_birth.place_id
                    LEFT JOIN humo_location l_bapt
                        ON l_bapt.location_id = e_bapt.place_id
                    WHERE p.pers_tree_id='" . $this->tree_id . "'
                        AND (l_birth.location_location !='' OR (l_birth.location_location ='' AND l_bapt.location_location !='')) " . $namesearch_string
                );
            } elseif ($_SESSION['type_death'] == 1) {
                /*
                $person_results = $this->dbh->query("SELECT pers_death_place, pers_death_date, pers_buried_place, pers_buried_date
                    FROM humo_persons WHERE pers_tree_id='" . $this->tree_id . "'
                    AND (pers_death_place !='' OR (pers_death_place ='' AND pers_buried_place !='')) " . $namesearch_string);
                */

                $person_results = $this->dbh->query(
                    "SELECT 
                        l_death.location_location AS pers_death_place,
                        l_burial.location_location AS pers_buried_place,
                        e_death.event_date AS pers_death_date,
                        e_burial.event_date AS pers_buried_date
                    FROM humo_persons p
                    LEFT JOIN humo_events e_death 
                        ON e_death.event_kind = 'death'
                        AND e_death.person_id = p.pers_id
                        AND e_death.event_tree_id = p.pers_tree_id
                    LEFT JOIN humo_events e_burial 
                        ON e_burial.event_kind = 'burial'
                        AND e_burial.person_id = p.pers_id
                        AND e_burial.event_tree_id = p.pers_tree_id
                    LEFT JOIN humo_location l_death
                        ON l_death.location_id = e_death.place_id
                    LEFT JOIN humo_location l_burial
                        ON l_burial.location_id = e_burial.place_id
                    WHERE p.pers_tree_id='" . $this->tree_id . "'
                        AND (l_death.location_location !='' OR (l_death.location_location ='' AND l_burial.location_location !='')) " . $namesearch_string
                );
            }

            while ($personDb = $person_results->fetch(PDO::FETCH_OBJ)) {
                if ($_SESSION['type_birth'] == 1) {
                    $place = $personDb->pers_birth_place;
                    $date = $personDb->pers_birth_date;
                    if (!$personDb->pers_birth_place and $personDb->pers_bapt_place) {
                        $place = $personDb->pers_bapt_place;
                    }
                    if (!$personDb->pers_birth_date and $personDb->pers_bapt_date) {
                        $date = $personDb->pers_bapt_date;
                    }
                } elseif ($_SESSION['type_death'] == 1) {
                    $place = $personDb->pers_death_place;
                    $date = $personDb->pers_death_date;
                    if (!$personDb->pers_death_place and $personDb->pers_buried_place) {
                        $place = $personDb->pers_buried_place;
                    }
                    if (!$personDb->pers_death_date and $personDb->pers_buried_date) {
                        $date = $personDb->pers_buried_date;
                    }
                }

                if (isset($locarray[$place])) {
                    // birthplace exists in location database
                    if ($date) {
                        $year = substr($date, -4);

                        if ($year > 1 and $year < $maps['slider_min']) {
                            $locarray[$place][3]++;
                        }
                        if ($year > 1 and $year < ($maps['slider_min'] + $maps['slider_step'])) {
                            $locarray[$place][4]++;
                        }
                        if ($year > 1 and $year < ($maps['slider_min'] + (2 * $maps['slider_step']))) {
                            $locarray[$place][5]++;
                        }
                        if ($year > 1 and $year < ($maps['slider_min'] + (3 * $maps['slider_step']))) {
                            $locarray[$place][6]++;
                        }
                        if ($year > 1 and $year < ($maps['slider_min'] + (4 * $maps['slider_step']))) {
                            $locarray[$place][7]++;
                        }
                        if ($year > 1 and $year < ($maps['slider_min'] + (5 * $maps['slider_step']))) {
                            $locarray[$place][8]++;
                        }
                        if ($year > 1 and $year < ($maps['slider_min'] + (6 * $maps['slider_step']))) {
                            $locarray[$place][9]++;
                        }
                        if ($year > 1 and $year < ($maps['slider_min'] + (7 * $maps['slider_step']))) {
                            $locarray[$place][10]++;
                        }
                        if ($year > 1 and $year < ($maps['slider_min'] + (8 * $maps['slider_step']))) {
                            $locarray[$place][11]++;
                        }
                        if ($year > 1 and $year < 2050) {
                            $locarray[$place][12]++;
                        }
                        $locarray[$place][13]++;  // array of all people incl people without birth date
                    } else {
                        $locarray[$place][13]++; // array of all people incl people without birth date
                    }
                }
            }
        }
        return $locarray;
    }
}
